#include "SliderInspector.h"

//******************************************************************************
//
//	File:		InstantiateBWindow.h
//
//	Description:	Unarchiving a BWindow instance.
//
//	Copyright 1996, International Lorienne Inc.
//
//******************************************************************************

#include <Window.h>
#include <string.h>

#pragma export on
SliderInspector* InstantiateSliderInspector(BMessage *message);
#pragma export off
SliderInspector* InstantiateSliderInspector(BMessage *message)
{

	SliderInspector *instance;
	BRect	frame;
	char	*label;
	ulong	win_type,win_flags;
	long 	i = 0;
	float	value;
	
	// Default values
	
	frame.left = 200;				// Default frame
	frame.top = 200;
	frame.right = 400;
	frame.bottom = 350;
	
	label = NULL;
	win_type = B_TITLED_WINDOW;								// TITLED Window
	win_flags = 0;

	if (message->HasPoint("Origin")) {
		BPoint origin = message->FindPoint("Origin");
		value = frame.Width();
		frame.left = origin.x;
		frame.right = frame.left + value;
		value = frame.Height();
		frame.top = origin.y;
		frame.bottom = frame.top + value;
	}	
	if (message->HasRect("Frame")) {
		frame = message->FindRect("Frame");
	}	
	if (message->HasString("Label")) {
		label = strdup(message->FindString("Label"));
	}	
	if (message->HasLong("Window Type")) {
		win_type = message->FindLong("Window Type");
	}	
	if (message->HasLong("Window Flags")) {
		win_flags = message->FindLong("Window Flags");
	}

	if (label == NULL) 	label = strdup("New Window");							// Default title

	instance = new SliderInspector(frame,label,(window_type) win_type,win_flags);
	free(label);
	return instance;
}